<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
class BNR extends REST_Controller
{
    var $date = "";
    var $xmlDocument = "";
    var $currency = array();

	public function __construct()
	{
		parent::__construct();
        $this->xmlDocument = file_get_contents("http://www.bnro.ro/nbrfxrates.xml");
        $this->parseXMLDocument();
	}
    public function index_get()
    {
        $result = (object) array("date"=> $this->date, "rates"=> $this->currency);
        $this->response($result, REST_Controller::HTTP_OK);
    }

    public function exchangeRate_get($currency)
    {
        foreach($this->currency as $line)
        {
            if($line["name"]==$currency)
            {
                return $line["value"];
                $this->response($line, REST_Controller::HTTP_OK);
            }
        }
        $this->response(["message"=> "not found"], REST_Controller::HTTP_BAD_REQUEST);
    }

    private function parseXMLDocument()
    {
        $xml = new SimpleXMLElement($this->xmlDocument);
        $this->date = (string)$xml->Header->PublishingDate;
        foreach($xml->Body->Cube->Rate as $line)
        {
            $this->currency[]=array("name" => (string)$line["currency"], "value" => (float)$line);
        }
    }
}