<?php

require APPPATH . 'controllers/Api.php';
class Tables extends Api
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('TablesModel');
	}

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function index_get($id = 0)
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2) {
			$roomId = $this->input->get('RoomId');
			$response = $this->TablesModel->get($id, $roomId);
			$this->response(['RoomId' => $roomId, 'data' => $response], REST_Controller::HTTP_OK);
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	public function unlockTable_put($id = 0)
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2 && !empty($id) && $id > 0) {
			$this->TablesModel->table_unlock($id);
			$this->response(true, REST_Controller::HTTP_OK);
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	public function validator_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2) {
			$id = $this->input->get('Id');
			$result = $this->TablesModel->open_validator($id);
			$this->response($result, REST_Controller::HTTP_OK);
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
}
