<?php

class ProductsModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}

	public function get($id = 0, $subcategoryId = 0)
	{
		if (!empty($id) && $id > 0) {
			$data = $this->db->get_where("TProduse", ['ID' => $id])->row_array();
		} else {
			if (!empty($subcategoryId) && $subcategoryId > 0) {
				$this->db->from("TProduse");
				$this->db->where(['IDSubCategorie' => $subcategoryId]);
				$this->db->order_by('Denumire', 'ASC');
				$data = $this->db->get()->result();
			} else {
				$this->db->from("TProduse");
				$this->db->order_by('Denumire', 'ASC');
				$data = $this->db->get()->result();
			}
		}
		return $data;
	}

	public function getPrinterIds($input)
	{
		$this->db->select('p.ID ProductId, p.Denumire, p.Pret, p.UM, t.Id PrinterType');
		$this->db->from("TProduse p");
		$this->db->join('TSubCategorii sc', 'p.IDSubCategorie = sc.IDSubCategorie');
		$this->db->join('TCategorii c', 'c.IDCategorie = sc.IdCategorie');
		$this->db->join('CategoryTypes t', 'c.TipCategorie = t.Type');
		$this->db->where_in('p.ID', $input);
		return $this->db->get()->result();
	}

	public function filterProducts($name = '')
	{
		$this->db->select('TProduse.ID as ProductId, TProduse.Denumire as Name, TProduse.Pret as Price');
		$this->db->from("TProduse");
		if (!empty($name) && strlen($name) > 0) {
			$this->db->like('LOWER(Denumire)', strtolower($name), 'both');
		}
		$this->db->order_by('Name', 'ASC');
		$this->db->limit(10);
		$data = $this->db->get()->result();
		return $data;
	}

	public function getByBarcode($barCode = '')
	{
		$data = [];
		if (!empty($barCode)) {
			$this->db->select('TProduse.ID as ProductId, TProduse.Denumire as Name, TProduse.Pret as Price,
            TProduse.UM as MesurementUnit, TProduse.Stoc as ProductStock, IFNULL(tva.Denumire, "N/A") as VATName,
            TProduse.PretAchizitie as SupplierPrice, TProduse.CodBare as BarCode, 
            TProduse.StocMinim as MinimalStock, TProduse.LimitaStoc as OptimalStock, 
            TProduse.CodPlu as InternalCode, IFNULL(tvaf.Denumire, "N/A") as SupplierVATName');
			$this->db->from("TProduse");
			$this->db->join("TTVA as tva", 'TProduse.TVA = tva.ID', 'left');
			$this->db->join("TTVA as tvaf", 'TProduse.TVAF = tvaf.ID', 'left');
			$this->db->where(['TProduse.CodBare' => $barCode]);
			$data =  $this->db->get()->row_object();
		}
		return $data;
	}

	public function getByProductId($id = 0)
	{
		$data = [];
		if (!empty($id) && $id > 0) {
			$this->db->select('TProduse.ID as ProductId, TProduse.Denumire as Name, TProduse.Pret as Price,
            TProduse.UM as MesurementUnit, TProduse.Stoc as ProductStock, IFNULL(tva.Denumire, "N/A") as VATName,
            TProduse.PretAchizitie as SupplierPrice, TProduse.CodBare as BarCode, 
            TProduse.StocMinim as MinimalStock, TProduse.LimitaStoc as OptimalStock, 
            TProduse.CodPlu as InternalCode, IFNULL(tvaf.Denumire, "N/A") as SupplierVATName');
			$this->db->from("TProduse");
			$this->db->join("TTVA as tva", 'TProduse.TVA = tva.ID', 'left');
			$this->db->join("TTVA as tvaf", 'TProduse.TVAF = tvaf.ID', 'left');
			$this->db->where(['TProduse.ID' => $id]);
			$data =  $this->db->get()->row_object();
		}
		return $data;
	}
}
