<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Settings.php';
require APPPATH . 'libraries/Format.php';
// use libraries\REST_Controller;
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");

class Api extends REST_Controller
{
	protected function __construct()
	{
		parent::__construct();
		$this->load->model('BaseModel');
		$this->load->helper(['jwt', 'authorization']);
	}
	protected function verify_request()
	{
		try {
			// Get all the headers
			$headers = $this->input->request_headers();
			// Extract the token
			if (!empty($headers) && !empty($headers['X-Api-Key'])) {
				$token = $headers['X-Api-Key'];
				// Use try-catch
				// JWT library throws exception if the token is not valid
				// Validate the token
				// Successfull validation will return the decoded user data else returns false
				$data = AUTHORIZATION::validateTimestamp($token);

				if ($data === false) {
					$status = parent::HTTP_UNAUTHORIZED;
					$response = ['status' => $status, 'error' => 'Unauthorized Access!'];
					$this->response($response, $status);
					$this->output->_display();
					exit();
				} else if ($data === true) {
					$status = parent::HTTP_UNAUTHORIZED;
					$response = ['status' => $status, 'error' => 'Unauthorized Access!', 'message' => 'Token has expired'];
					$this->response($response, $status);
					$this->output->_display();
					exit();
				} else {
					return $data;
				}
			} else {
				$status = parent::HTTP_UNAUTHORIZED;
				$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
				$this->response($response, $status);
				$this->output->_display();
				exit();
			}
		} catch (Exception $e) {
			// Token is invalid
			// Send the unathorized access message
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
	protected function verify_token()
	{
		try {
			// Get all the headers
			$headers = $this->input->request_headers();
			// Extract the token
			if (!empty($headers) && !empty($headers['X-Api-Key'])) {
				$token = $headers['X-Api-Key'];
				// Use try-catch
				// JWT library throws exception if the token is not valid
				// Validate the token
				// Successfull validation will return the decoded user data else returns false
				$data = AUTHORIZATION::validateToken($token);
				if ($data === false) {
					$status = parent::HTTP_UNAUTHORIZED;
					$response = ['status' => $status, 'error' => 'Unauthorized Access!'];
					$this->response($response, $status);
					$this->output->_display();
					exit();
				} else {
					return $data;
				}
			} else {
				$status = parent::HTTP_UNAUTHORIZED;
				$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
				$this->response($response, $status);
				$this->output->_display();
				exit();
			}
		} catch (Exception $e) {
			// Token is invalid
			// Send the unathorized access message
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
	protected function verify_refresh_token()
	{
		try {
			// Get all the headers
			$headers = $this->input->request_headers();
			// Extract the token
			if (!empty($headers) && !empty($headers['X-Api-Refresh'])) {
				$token = $headers['X-Api-Refresh'];
				// Use try-catch
				// JWT library throws exception if the token is not valid
				// Validate the token
				// Successfull validation will return the decoded user data else returns false
				$data = AUTHORIZATION::validateToken($token);
				if ($data === false) {
					$status = parent::HTTP_UNAUTHORIZED;
					$response = ['status' => $status, 'error' => 'Unauthorized Access!'];
					$this->response($response, $status);
					$this->output->_display();
					exit();
				} else {
					return $data;
				}
			} else {
				$status = parent::HTTP_UNAUTHORIZED;
				$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
				$this->response($response, $status);
				$this->output->_display();
				exit();
			}
		} catch (Exception $e) {
			// Token is invalid
			// Send the unathorized access message
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	protected function verify_app_id()
	{
		$headers = $this->input->request_headers();
		if (!empty($headers) && !empty($headers['X-App-Id'])) {
			$app_id = $headers['X-App-Id'];
			if ($app_id == '3b73df60-bd46-479c-a38b-c8f23ca2404d') {
				//Inventory app
				return 1;
			} else if ($app_id == 'cf9124c7-fc35-4d2d-b66d-3f85304c0646') {
				//Order app
				return 2;
			} else if ($app_id == '3196f582-8379-4b7f-90d7-6a37ea39b28c') {
				//Washing app
				return 3;
			} else if ($app_id == '96997750-1ee0-4faf-8fed-d87819e0585d') {
				//external access
				return 4;
			} else if ($app_id == 'e67c36c7-35d5-4360-b1fb-3ec437cef91b') {
				//Mobile Calls app
				return 5;
			} else {
				$status = parent::HTTP_UNAUTHORIZED;
				$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
				$this->response($response, $status);
				$this->output->_display();
				exit();
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	protected function verify_settings($settings)
	{
		return $this->BaseModel->verifySetting($settings);
	}

	protected function invStatus()
	{
		return $this->BaseModel->inventoryStatus();
	}

	protected function recStatus()
	{
		return $this->BaseModel->receiptStatus();
	}

	protected function nirStatus()
	{
		return $this->BaseModel->nirStatus();
	}
}
