<?php

require APPPATH . 'controllers/Api.php';
class Inventory extends Api
{

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('InventoryModel');
		$this->load->model('ProductsModel');
		$this->load->model('InventoryUserModel');
	}

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */

	public function index_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$id = $this->input->get('id');
			$barCode = $this->input->get('BarCode');
			if (!empty($barCode) && $barCode != '') {
				$data = $this->InventoryModel->getByBarcode($barCode);
				$this->response($data, REST_Controller::HTTP_OK);
			} elseif ($id > 0) {
				$data = $this->InventoryModel->getByProductId($id);
				$this->response($data, REST_Controller::HTTP_OK);
			} else {
				$status = REST_Controller::HTTP_BAD_REQUEST;
				$response = ['status' => $status, 'error' => 'Barcode invalid!'];
				$this->response($response, $status);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function index_post()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$input = (object)$this->post();
			$inventoryStatus = parent::invStatus();
			if (!empty($input) && !empty($input->ProductId) && $inventoryStatus == 1) {
				$product = (object)$this->ProductsModel->get($input->ProductId, -1);
				if (!empty($product) && !empty($product->ID)) {
					$inventoryUser = (object)array(
						'UserId' => $data->id,
						'ProductId' => $input->ProductId,
						'Quantity' => $input->Quantity
					);
					$result = $this->InventoryUserModel->post($inventoryUser);
					$this->response($result, REST_Controller::HTTP_OK);
				} else {
					$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function index_put()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$input = (object)$this->put();
			$inventoryStatus = parent::invStatus();
			if (!empty($input) && !empty($input->ProductId) && $inventoryStatus == 1) {
				$inventoryProduct = (object)$this->InventoryModel->get($input->ProductId);
				if (!empty($inventoryProduct) && !empty($inventoryProduct->ProductId)) {
					$inventoryUser = (object)array(
						'UserId' => $data->id,
						'ProductId' => $input->ProductId,
						'Quantity' => $input->AddedQuantity
					);
					$result = $this->InventoryUserModel->post($inventoryUser);
					$this->response($result, REST_Controller::HTTP_OK);
				} else {
					$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
}
