<?php

//require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'controllers/Api.php';
class Orders extends Api
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('TureModel');
		$this->load->model('OrdersModel');
		$this->load->model('TablesModel');
		$this->load->model('ProductsModel');
		$this->load->model('PrintersModel');
		$this->load->model('OrderItemsModel');
	}
	public function index_get($id = 0)
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2) {
			$tableId = $this->input->get('TableId');
			$validation = $this->OrdersModel->validate_user($data, $tableId);
			if (!empty($tableId) && $tableId > 0 && $validation->result) {
				$response = $this->OrdersModel->get($id, $tableId);
				if (!empty($response)) {
					foreach ($response as &$result) {
						$result->OrderItems = $this->OrderItemsModel->get(0, $result->OrderId);
					}
				}
				$this->response($response, REST_Controller::HTTP_OK);
			} else {
				$status = parent::HTTP_UNAUTHORIZED;
				$response = ['status' => $status, 'error' => 'Unauthorized Access!'];
				if ($validation->userId > 0) {
					$response['userId'] = $validation->userId;
					$response['username'] = $validation->username;
				}
				$this->response($response, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	public function index_post()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2) {
			file_get_contents('php://input');
			$input = (object)$this->post();
			if (!empty($input) && !empty($input->OrderItems)) {
				$now = date('Y-m-d H:i:s');
				$bon = (object)$this->OrdersModel->get_last_id();
				$order = (object)$this->OrdersModel->get_order_number();
				$turaId = (object)$this->TureModel->get_last_id();
				$bonHeader = (object)array(
					'UserId' => $data->id,
					'NumeUser' => $data->username,
					'BonActiv' => '1',
					'Data' => $now,
					'CodClient' => $input->CodClient,
					'NrOrdine' => $order->NrOrdine,
					'TipVanzare' => '0',
					'IdTura' => $turaId->Id,
					'IdBonTemporar' => ($bon->Id + 1),
					'TotalProtocol' => '0',
					'TotalFiscal' => '0'
				);
				$toPrint = array();
				$products = array();
				foreach ($input->OrderItems as &$p) {
					$p = (object)$p;
					array_push($toPrint, (object)array(
						'IdUser' => $data->id,
						'IdBonTemp' => ($bon->Id + 1),
						'IDProdus' => $p->ProductId,
						'IDMasaActiva' => $p->TableId,
						'Cantitate' => $p->Quantity,
						'Imprimat' => 0,
						'InLucru' => 1,
						'Comentarii' => $p->Comentarii
					));
					if (!in_array($p->ProductId, array_column($products, 'IDProdus'), $strict = true)) {
						array_push($products, (object)array(
							'IdUser' => $data->id,
							'IdBonTemp' => ($bon->Id + 1),
							'IDProdus' => (int)$p->ProductId,
							'IDMasaActiva' => (int)$p->TableId,
							'Cantitate' => (float)$p->Quantity,
							'Imprimat' => 0,
							'InLucru' => 1,
							'Comentarii' => $p->Comentarii
						));
					} else {
						foreach ($products as &$prod) {
							if ($prod->IDProdus == $p->ProductId) {
								$prod->Cantitate = $prod->Cantitate + $p->Quantity;
								$prod->Comentarii = $prod->Comentarii . "\n" . $p->Comentarii;
							}
						}
					}
				}
				if (count($products) == $this->OrderItemsModel->product_validator(array_column($products, 'IDProdus'))) {
					$result = array();
					array_push($result, ["Add Order: " => $this->OrdersModel->post($bonHeader, $input->TableId)]);
					array_push($result, ["Add Items: " => $this->OrderItemsModel->post_batch($products)]);
					$this->OrderItemsModel->post_batch_temp($products);

					if (!empty($products) && count($products) > 0) {
						$printers = $this->PrintersModel->get();
						if (!empty($printers) && count($printers) > 0) {
							$this->PrintOrder($bonHeader, $printers, $toPrint, $now, $order->NrOrdine, $input->TableId);
						}
					}
					$this->response($result, REST_Controller::HTTP_OK);
				} else {
					$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	public function index_put($id)
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 2) {
			$input = (object)$this->put();
			if (!empty($input) && !empty($input->OrderItems) && $input->OrderId > 0) {
				$bon = (object)$this->OrdersModel->get($id);
				if (!empty($bon)) {
					$bon->OrderItems = $this->OrderItemsModel->getInternal($input->OrderId);
					$toPrint = array();
					$toAdd = array();
					uasort($input->OrderItems, function ($first, $second) {
						return $first['OrderItemId'] <=> $second['OrderItemId'];
					});
					foreach ($input->OrderItems as $p) {
						$pr = ((object)$p);
						if (in_array($pr->OrderItemId, array_column($bon->OrderItems, 'ID'), true)) {
							$key = array_search($pr->OrderItemId, array_column($bon->OrderItems, 'ID'), $strict = true);
							$prod = &$bon->OrderItems[$key];
							$prod->Comentarii = $pr->Comentarii;
							if ($prod->Cantitate < $pr->Quantity) {
								array_push($toPrint, (object)array(
									'IdUser' => $data->id,
									'IdBonTemp' => $id,
									'IDProdus' => $pr->ProductId,
									'IDMasaActiva' => $pr->TableId,
									'Cantitate' => $pr->Quantity - $prod->Cantitate,
									'Imprimat' => 0,
									'InLucru' => 1,
									'Comentarii' => $pr->Comentarii
								));
								$prod->Cantitate = $pr->Quantity;
							}
						} else if (in_array($pr->ProductId, array_column($bon->OrderItems, 'IDProdus'), true)) {
							$key = array_search($pr->ProductId, array_column($bon->OrderItems, 'IDProdus'), $strict = true);
							$prod = &$bon->OrderItems[$key];
							$prod->Cantitate = $prod->Cantitate + $pr->Quantity;
							$prod->Comentarii = $prod->Comentarii . "\n" . $pr->Comentarii;
							array_push($toPrint, (object)array(
								'IdUser' => $data->id,
								'IdBonTemp' => $id,
								'IDProdus' => $pr->ProductId,
								'IDMasaActiva' => $pr->TableId,
								'Cantitate' => $pr->Quantity,
								'Imprimat' => 0,
								'InLucru' => 1,
								'Comentarii' => $pr->Comentarii
							));
						} else if (in_array($pr->ProductId, array_column($toAdd, 'IDProdus'), true)) {
							$key = array_search($pr->ProductId, array_column($toAdd, 'IDProdus'), $strict = true);
							$prod = &$toAdd[$key];
							$prod->Cantitate = $prod->Cantitate + $pr->Quantity;
							$prod->Comentarii = $prod->Comentarii . "\n" . $pr->Comentarii;
							array_push($toPrint, (object)array(
								'IdUser' => $data->id,
								'IdBonTemp' => $id,
								'IDProdus' => $pr->ProductId,
								'IDMasaActiva' => $pr->TableId,
								'Cantitate' => $pr->Quantity,
								'Imprimat' => 0,
								'InLucru' => 1,
								'Comentarii' => $pr->Comentarii
							));
						} else {
							array_push($toAdd, (object)array(
								'IdUser' => $data->id,
								'IdBonTemp' => $id,
								'IDProdus' => $pr->ProductId,
								'IDMasaActiva' => $pr->TableId,
								'Cantitate' => $pr->Quantity,
								'Imprimat' => 0,
								'InLucru' => 1,
								'Comentarii' => $pr->Comentarii
							));
							array_push($toPrint, (object)array(
								'IdUser' => $data->id,
								'IdBonTemp' => $id,
								'IDProdus' => $pr->ProductId,
								'IDMasaActiva' => $pr->TableId,
								'Cantitate' => $pr->Quantity,
								'Imprimat' => 0,
								'InLucru' => 1,
								'Comentarii' => $pr->Comentarii
							));
						}
					}
					$this->TablesModel->table_unlock($input->TableId);
					$result = array();
					if (!empty($toAdd))
						array_push($result, ["Add Result: " => $this->OrderItemsModel->post_batch($toAdd)]);
					if (!empty($bon->OrderItems))
						array_push($result, ["Update Result: " => $this->OrderItemsModel->put_batch($bon->OrderItems)]);
					// if(parent::verify_settings(Settings::Printing)){

					// }
					if (!empty($toPrint) && count($toPrint) > 0) {
						$printers = $this->PrintersModel->get();
						if (!empty($printers) && count($printers) > 0) {
							$this->PrintOrder($bon, $printers, $toPrint, date('Y-m-d H:i:s'), $bon->NrOrdine, $input->TableId);
						}
					}
					$this->response($result, REST_Controller::HTTP_OK);
				} else {
					$now = date('Y-m-d H:i:s');
					$id = (object)$this->OrdersModel->get_last_id();
					$order = (object)$this->OrdersModel->get_order_number();
					$turaId = (object)$this->TureModel->get_last_id();
					$bonHeader = (object)array(
						'UserId' => $data->id,
						'NumeUser' => $data->username,
						'BonActiv' => '1',
						'Data' => $now,
						'CodClient' => $input->CodClient,
						'NrOrdine' => $order->NrOrdine,
						'TipVanzare' => '0',
						'IdTura' => $turaId->Id,
						'IdBonTemporar' => ($id->Id + 1),
						'TotalProtocol' => '0',
						'TotalFiscal' => '0'
					);
					$products = array();
					foreach ($input->OrderItems as &$p) {
						$p = (object)$p;
						if (!in_array($p->ProductId, array_column($products, 'IDProdus'), true)) {
							array_push($products, (object)array(
								'IdUser' => $data->id,
								'IdBonTemp' => ($id->Id + 1),
								'IDProdus' => $p->ProductId,
								'IDMasaActiva' => $p->TableId,
								'Cantitate' => $p->Quantity,
								'Imprimat' => 0,
								'InLucru' => 1,
								'Comentarii' => $p->Comentarii
							));
						} else {
							foreach ($products as &$prod) {
								if ($prod->IDProdus == $p->ProductId) {
									$prod->Cantitate = $prod->Cantitate + $p->Quantity;
									$prod->Comentarii = $prod->Comentarii . "\n" . $p->Comentarii;
								}
							}
						}
					}
					if (count($products) == $this->OrderItemsModel->product_validator(array_column($products, 'IDProdus'))) {
						$result = array();
						array_push($result, ["Add Order: " => $this->OrdersModel->post($bonHeader, $input->TableId)]);
						array_push($result, ["Add Items: " => $this->OrderItemsModel->post_batch($products)]);
						$this->OrderItemsModel->post_batch_temp($products);
						// if(parent::verify_settings(Settings::Printing)){

						// }
						if (!empty($products) && count($products) > 0) {
							$printers = $this->PrintersModel->get();
							if (!empty($printers) && count($printers) > 0) {
								$this->PrintOrder($bonHeader, $printers, $products, $now, $order->NrOrdine, $input->TableId);
							}
						}
						$this->response($result, REST_Controller::HTTP_OK);
					} else {
						$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
					}
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	private function PrintOrder($bon, $printers, $products, $now, $orderNr, $tableId)
	{
		$ids = $this->ProductsModel->getPrinterIds(array_column($products, 'IDProdus'));
		foreach ($ids as $id) {
			$key = array_search($id->ProductId, array_column($products, 'IDProdus'), $strict = true);
			$prod = &$products[$key];
			$prod->Denumire = $id->Denumire;
			$prod->PrinterType = $id->PrinterType;
			$prod->Pret = $id->Pret;
			$prod->UM = $id->UM;
		}
		$request = array(
			'Masa' => (int)$tableId,
			'NrOrdine' => $orderNr,
			'BonId' => (int)$bon->IdBonTemporar,
			'Casier' => $bon->NumeUser,
			'Data' => date_format(date_create($now), "c"),
			'Printers' => $printers,
			'Products' => $products
		);
		$url = "http://" . Settings::PrintHubIP . ":450/print/print-order";
		$request_string = json_encode($request);

		//open connection
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt(
			$ch,
			CURLOPT_HTTPHEADER,
			array(
				'Content-Type: application/json',
				'Content-Length: ' . strlen($request_string)
			)
		);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  // Make it so the data coming back is put into a string
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request_string);  // Insert the data

		//execute post
		$result = curl_exec($ch);
		curl_close($ch);
		// print_r($result);
	}
}
