<?php
require APPPATH . 'controllers/Api.php';
class Login extends Api
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('LoginModel');
		$this->load->helper(['jwt', 'authorization']);
	}

	public function index_post()
	{
		// Have dummy user details to check user credentials
		// send via postman 
		$app_id = parent::verify_app_id();
		// $app_id = $this->post('APP_ID');
		$username = $this->post('username');
		$password = $this->post('password');
		$userData = $this->LoginModel->login($username, $password);
		// Check if valid user
		if (!empty($userData)) {
			$CI = &get_instance();
			$now = strtotime(date('Y-m-d H:i:s'));
			$refresh_timestamp = strtotime($userData->Timestamp);
			$refresh_timeout = $CI->config->item('refresh_token_timeout') * 60 * 60 * 24;

			if ($now < $refresh_timestamp + $refresh_timeout) {
				$refresh_timestamp = strtotime(date('Y-m-d H:i:s'));
				$userData->Secret = $this->Guid() . $this->Guid();
				$this->LoginModel->UpdateRefreshToken($userData->ID, $userData->Secret);
			}
			$timestamp = strtotime(date('Y-m-d H:i:s')) + $CI->config->item('token_timeout') * 60 * 60;
			$access_token = AUTHORIZATION::generateToken(
				[
					'id' => $userData->ID,
					'username' => $userData->NumeUtilizator,
					'firstname' => $userData->PrenumeUser,
					'lastname' => $userData->NumeUser,
					'role' => $userData->TipUser,
					'timestamp' => $timestamp,
					'phone' => $userData->Telefon
				]
			);
			$refresh_token = AUTHORIZATION::generateToken(
				[
					'secret' => $userData->Secret,
					'timestamp' => $refresh_timestamp + $refresh_timeout
				]
			);
			//
			// Prepare the response
			$status = parent::HTTP_OK;
			$response = [
				'status' => $status,
				'token_type' => 'bearer',
				'iss' => 'http://aristarch.ro/',
				'access_token' => $access_token,
				'expires_in' => $CI->config->item('token_timeout') * 60 * 60,
				'timestamp' => $timestamp,
				'refresh_token' => $refresh_token,
				'Username' => $userData->NumeUtilizator,
				'Firstname' => $userData->PrenumeUser,
				'Lastname' => $userData->NumeUser,
				'Role' => $userData->TipUser,
				'Phone' => $userData->Telefon
			];
			$inventoryStatus = parent::invStatus();
			if ($app_id == 1) {
				$response = array_merge($response, ['inventoryStatus' => parent::invStatus()]);
				$response = array_merge($response, ['receiptStatus' => parent::recStatus()]);
				$response = array_merge($response, ['nirStatus' => parent::nirStatus()]);
			}
			$this->response($response, $status);
		} else {
			$status = parent::HTTP_NOT_FOUND;
			$response = ['status' => $status, 'error' => 'Invalid username or password!', 'message' => 'Access Denied!'];
			$this->response($response, $status);
		}
	}
	public function refresh_get()
	{
		$data = parent::verify_token();
		$app_id = parent::verify_app_id();
		$dataRefresh = parent::verify_refresh_token();
		$valid = $this->LoginModel->VerifyRefreshToken($data->id, $dataRefresh->secret);
		if (!empty($data) && $valid) {
			$CI = &get_instance();
			$refresh = $this->ActualizeSecret($data);
			$refresh_timestamp = $CI->config->item('refresh_token_timeout') * 60 * 60 * 24;
			$timestamp = strtotime(date('Y-m-d H:i:s')) + $CI->config->item('token_timeout') * 60 * 60;
			$access_token = AUTHORIZATION::generateToken(
				[
					'id' => $data->id,
					'username' => $data->username,
					'firstname' => $data->firstname,
					'lastname' => $data->lastname,
					'role' => $data->role,
					'timestamp' => $timestamp,
					'phone' => $data->phone
				]
			);
			$refresh_token = AUTHORIZATION::generateToken(
				[
					'secret' => $refresh,
					'timestamp' => $refresh_timestamp
				]
			);
			// Prepare the response
			$status = parent::HTTP_OK;
			$response = [
				"status" => $status,
				"token_type" => "bearer",
				'iss' => 'http://aristarch.ro/',
				"access_token" => $access_token,
				"expires_in" => $CI->config->item('token_timeout') * 60 * 60,
				"refresh_token" => $refresh_token
			];
			if ($app_id == 1) {
				$response = array_merge($response, ['inventoryStatus' => parent::invStatus()]);
				$response = array_merge($response, ['receiptStatus' => parent::recStatus()]);
				$response = array_merge($response, ['nirStatus' => parent::nirStatus()]);
			}
			$this->response($response, $status);
		} else {
			$status = parent::HTTP_NOT_FOUND;
			$response = ['status' => $status, 'error' => 'Invalid token', 'message' => 'Access Denied!'];
			$this->response($response, $status);
		}
	}
	private function ActualizeSecret($user)
	{
		$refresh = $this->Guid() . $this->Guid();
		$data = $this->LoginModel->UpdateRefreshToken($user->id, $refresh);
		return $refresh;
	}
	private function Guid()
	{
		if (function_exists('com_create_guid') === true) {
			return trim(com_create_guid(), '{}');
		}

		return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
	}
}
