<?php

class InventoryModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}

	public function getByBarcode($barCode = '')
	{
		$data = [];
		if (!empty($barCode)) {
			$this->db->select('TProduse.ID as ProductId, TProduse.Denumire as Name, TProduse.Pret as Price,
            TProduse.Stoc as ProductStock, TProduse.CodBare as BarCode, IFNULL(tva.Denumire, "N/A") as VATName');
			$this->db->from("TProduse");
			$this->db->join("TTVA as tva", 'TProduse.TVA = tva.ID', 'left');
			$this->db->where(['TProduse.CodBare' => $barCode]);
			$data =  $this->db->get()->row_object();
		}
		return $data;
	}

	public function getByProductId($id = 0)
	{
		$data = [];
		if (!empty($id) && $id > 0) {
			$this->db->select('TProduse.ID as ProductId, TProduse.Denumire as Name, TProduse.Pret as Price,
            TProduse.Stoc as ProductStock, TProduse.CodBare as BarCode, IFNULL(tva.Denumire, "N/A") as VATName');
			$this->db->from("TProduse");
			$this->db->join("TTVA as tva", 'TProduse.TVA = tva.ID', 'left');
			$this->db->where(['TProduse.ID' => $id]);
			$data =  $this->db->get()->row_object();
		}
		return $data;
	}

	public function get($id = 0)
	{
		$data = [];
		if (!empty($id) && $id > 0) {
			$this->db->select('TInventar.ProdusId as ProductId, TInventar.Denumire as Name, 
            TInventar.StocInventar as InventoryStock, TInventar.StocProdus as ProductStock, 
            TInventar.Diferenta as Diference');
			$this->db->from("TInventar");
			$this->db->where(['TInventar.ProdusId' => $id]);
			$data =  $this->db->get()->row_object();
		}
		return $data;
	}
	public function status()
	{
		$this->db->select('InventarActiv');
		$this->db->from("TSerieF");
		return $this->db->get()->row_object()->InventarActiv;
	}

	public function post($input)
	{
		return $this->db->insert('TInventar', $input);
		if ($this->db->_error_message()) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $input->ProdusId . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function put($input)
	{
		$this->db->set('StocInventar', 'StocInventar+' . $input->AddedQuantity, false);
		$this->db->set('Diferenta', 'Diferenta+' . $input->AddedQuantity, false);
		$this->db->where('ProdusId', $input->ProductId);
		$this->db->update('TInventar');

		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $input->ProductId . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}
	public function index_delete($id)
	{
		$this->db->delete('TInventar', array('ProdusId' => $id));
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $id . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}
}
